package ru.yandex.webmaster3.storage.host.dao;


import org.joda.time.Instant;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

@Repository
public class CommercialOwnersYDao extends AbstractYDao {
    private static final String TABLE_NAME = "commercial_owners";

    public CommercialOwnersYDao() {
        super(PREFIX_WEBMASTER3, TABLE_NAME);
    }

    public boolean containsHost(WebmasterHostId hostId) {
        return select(F.HOST_ID)
                .where(F.HOST_ID.eq(hostId))
                .limit(1)
                .queryOne() != null;
    }

    public void clearOldRecords(Instant ts) {
        delete().where(F.UPDATE_TIME.lt(ts)).execute();
    }

    private static class F {
        static final Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
        static final Field<Instant> UPDATE_TIME = Fields.jodaInstantField("update_time");
    }
}
