package ru.yandex.webmaster3.storage.host.dao;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.host.data.HostRobotsTxtInfo;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.ValueDataMapper;

import java.util.Collection;
import java.util.List;

/**
 * @author leonidrom
 */
@Repository
public class HostRobotsTxtInfoYDao extends AbstractYDao {
    public HostRobotsTxtInfoYDao() {
        super(PREFIX_HOST, "host_robots_txt_info");
    }

    public void updateInfos(List<HostRobotsTxtInfo> batch) {
        batchUpdate(UPDATE_VALUE_MAPPER, batch).execute();
    }

    public void deleteInfos(Collection<WebmasterHostId> hostIds) {
        if (hostIds.isEmpty()) {
            return;
        }

        delete().where(F.HOST_ID.in(hostIds)).execute();
    }

    public WebmasterHostId getTargetForHost(WebmasterHostId hostId)  {
        return select(F.TARGET_HOST_ID)
                .where(F.HOST_ID.eq(hostId))
                .queryOne();
    }

    private static final DataMapper<HostRobotsTxtInfo> MAPPER = DataMapper.create(F.HOST_ID, F.HAS_ROBOTS_TXT, F.TARGET_HOST_ID, HostRobotsTxtInfo::new);

    private static final ValueDataMapper<HostRobotsTxtInfo> UPDATE_VALUE_MAPPER = ValueDataMapper.create(
            Pair.of(F.HOST_ID, r -> F.HOST_ID.get(r.getHostId())),
            Pair.of(F.TARGET_HOST_ID, r -> F.TARGET_HOST_ID.get(r.getHostId())),
            Pair.of(F.HAS_ROBOTS_TXT, r -> F.HAS_ROBOTS_TXT.get(r.isHasRobotsTxt()))
    );

    private static class F {
        private static final Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
        private static final Field<WebmasterHostId> TARGET_HOST_ID = Fields.hostIdField("target_host_id");
        private static final Field<Boolean> HAS_ROBOTS_TXT = Fields.boolField("has_robots_txt").withDefault(true);
    }
}
