package ru.yandex.webmaster3.storage.host.moderation;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author leonidrom
 */

/**
 * Базовый класс для запросов на модерацию в Yt
 */
public abstract class AbstractHostModerationYtRequest {
    private final UUID requestId;
    private final WebmasterHostId hostId;
    private final DateTime createdDate;

    public AbstractHostModerationYtRequest(UUID requestId, WebmasterHostId hostId, DateTime createdDate) {
        this.requestId = requestId;
        this.hostId = hostId;
        this.createdDate = createdDate;
    }

    public UUID getRequestId() {
        return requestId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public DateTime getCreatedDate() {
        return createdDate;
    }

    /**
     * @return true, если заявка была полностью автомодерирована и не нуждается в модерации человеком.
     * Такие заявки не уходят в Янг, а сразу добавляются в архивную табличку с результатами.
     */
    public abstract boolean isAutoModerated();
}
