package ru.yandex.webmaster3.storage.host.moderation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;

import java.util.UUID;


/**
 * @author leonidrom
 */
@ToString
public abstract class AbstractHostModerationYtResult {
    private final String host;
    private final String requestId;
    private final String assessor;
    private final String moderationDate;

    public AbstractHostModerationYtResult(
            String host,
            String requestId,
            String assessor,
            String moderationDate) {
        this.host = host;
        this.requestId = requestId;
        this.assessor = assessor;
        this.moderationDate = moderationDate;
    }

    @JsonIgnore
    public WebmasterHostId getHostId() {
        return IdUtils.urlToHostId(host);
    }

    @JsonIgnore
    public UUID getRequestId() {
        return UUID.fromString(requestId);
    }

    @JsonIgnore
    public String getAssessor() {
        return assessor;
    }

    @JsonIgnore
    public DateTime getModerationDate() {
        return ISODateTimeFormat.dateTime().parseDateTime(moderationDate);
    }
}
