package ru.yandex.webmaster3.storage.host.moderation.camelcase;

import lombok.Builder;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.ToString;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * User: azakharov
 * Date: 17.07.14
 * Time: 10:51
 */
@Builder
@RequiredArgsConstructor
@Getter
@ToString
public class DisplayNameRequest {
    private final WebmasterHostId hostId;
    private final UUID requestId;
    private final String displayName;
    private final HostDisplayNameModerationRequestState state;
    private final DateTime creationDate;
    private final DateTime modificationDate;

    // пользователь закрыл баннер про заявку в интерфейсе ВМ, больше его показывать не надо
    private final boolean isUserClosedInfoBanner;
    private final Long userId;
    private final String assessorId;

    // WMC-7692: запрошенное имя проросло в Поиске
    private final boolean isClosed;

    public DisplayNameRequest(
            WebmasterHostId hostId,
            UUID requestId,
            String displayName,
            HostDisplayNameModerationRequestState state,
            DateTime creationDate,
            DateTime modificationDate,
            boolean isUserClosedInfoBanner,
            Long userId,
            String assessorId)
    {
        this(hostId, requestId, displayName, state, creationDate, modificationDate, isUserClosedInfoBanner, userId, assessorId, false);
    }
}
