package ru.yandex.webmaster3.storage.host.moderation.camelcase;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * User: azakharov
 * Date: 26.02.15
 * Time: 16:18
 */
public enum HostDisplayNameModerationRequestState implements IntEnum {
    @Description("Заявка рассматривается")
    IN_PROGRESS(1),
    @Description("Заявка принята")
    ACCEPTED(2),
    @Description("Заявка отклонена")
    REFUSED(3),
    @Description("Заявка отозвана пользователем")
    CANCELLED(5);

    private final int id;

    HostDisplayNameModerationRequestState(int id) {
        this.id = id;
    }

    public int getId() {
        return id;
    }

    @Override
    public int value() {
        return id;
    }

    public static final IntEnumResolver<HostDisplayNameModerationRequestState> R = IntEnumResolver.r(HostDisplayNameModerationRequestState.class);
}

