package ru.yandex.webmaster3.storage.host.moderation.camelcase;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author avhaliullin
 */
public enum HostDisplayNameModerationResolutionEnum implements IntEnum {
    ACCEPTED(0),
    REFUSED(1);

    private final int value;

    HostDisplayNameModerationResolutionEnum(int value) {
        this.value = value;
    }

    public boolean isAccepted() {
        return this == ACCEPTED;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<HostDisplayNameModerationResolutionEnum> R = IntEnumResolver.r(HostDisplayNameModerationResolutionEnum.class);
}
