package ru.yandex.webmaster3.storage.host.moderation.camelcase;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.host.moderation.AbstractHostModerationYtRequest;

import java.util.UUID;

/**
 * @author leonidrom
 */
public class HostDisplayNameModerationYtRequest extends AbstractHostModerationYtRequest {
    private final String requestedDisplayName;
    private final String currentDisplayName;
    private final String userComment;
    private final boolean isAutoModerated;

    public HostDisplayNameModerationYtRequest(WebmasterHostId hostId, UUID requestId, DateTime createdDate,
                                              String requestedDisplayName, String currentDisplayName, String userComment,
                                              boolean isAutoModerated) {
        super(requestId, hostId, createdDate);
        this.requestedDisplayName = requestedDisplayName;
        this.currentDisplayName = currentDisplayName;
        this.userComment = userComment;
        this.isAutoModerated = isAutoModerated;
    }

    public String getRequestedDisplayName() {
        return requestedDisplayName;
    }

    public String getCurrentDisplayName() {
        return currentDisplayName;
    }

    public String getUserComment() {
        return userComment;
    }

    @Override
    public boolean isAutoModerated() {
        return isAutoModerated;
    }
}
