package ru.yandex.webmaster3.storage.host.moderation.camelcase;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;
import ru.yandex.webmaster3.storage.host.moderation.AbstractHostModerationYtResult;

/**
 * @author leonidrom
 */
@ToString(callSuper = true)
public class HostDisplayNameModerationYtResult extends AbstractHostModerationYtResult {
    private final boolean isRejected;

    @JsonCreator
    public HostDisplayNameModerationYtResult(@JsonProperty("Host") String host,
                                             @JsonProperty("RequestId") String requestId,
                                             @JsonProperty("Assessor") String assessor,
                                             @JsonProperty("ModerationDate") String moderationDate,
                                             @JsonProperty("Reject") boolean isRejected) {
        super(host, requestId, assessor, moderationDate);
        this.isRejected = isRejected;
    }

    public boolean isRejected() {
        return isRejected;
    }
}
