package ru.yandex.webmaster3.storage.host.moderation.regions;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.Set;
import java.util.UUID;

/**
 * @author leonidrom
 */
public class HostModeratedRegions {
    private final WebmasterHostId hostId;
    private final Set<Integer> regions;
    private final Set<Integer> prevRegions;
    private final DateTime created;

    public HostModeratedRegions(WebmasterHostId hostId,
                                Set<Integer> regions, Set<Integer> prevRegions,
                                DateTime created) {
        this.hostId = hostId;
        this.regions = regions;
        this.prevRegions = prevRegions;
        this.created = created;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    /**
     * Текущие отмодерированные регионы (но возможно пока не проросшие)
     */
    public Set<Integer> getRegions() {
        return regions;
    }

    /**
     *  Отмодерированные и проросшие в поиске регионы, которые были у хоста на момент,
     *  когда последние отмодерированные, но возможно еще не проросшие в поиске,
     *  регионы были положены в базу
     */
    public Set<Integer> getPrevRegions() {
        return prevRegions;
    }

    public DateTime getCreated() {
        return created;
    }
}
