package ru.yandex.webmaster3.storage.host.moderation.regions;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.Set;
import java.util.UUID;

/**
 * @author leonidrom
 */
public class HostRegionsModerationRequest {
    private final WebmasterHostId hostId;
    private final UUID requestId;
    private final DateTime updateDate;
    private final HostRegionsModerationRequestStatus status;
    private final Set<Integer> currentRegions;
    private final Set<Integer> requestedRegions;
    private final Set<Integer> acceptedRegions;
    private final String assessorId;
    private final boolean userClosed;
    private final String evidenceUrl;


    public HostRegionsModerationRequest(WebmasterHostId hostId, UUID requestId, DateTime updateDate,
                                        HostRegionsModerationRequestStatus status,
                                        Set<Integer> currentRegions, Set<Integer> requestedRegions, Set<Integer> acceptedRegions,
                                        String assessorId, boolean userClosed, String evidenceUrl) {
        this.hostId = hostId;
        this.requestId = requestId;
        this.updateDate = updateDate;
        this.status = status;
        this.currentRegions = currentRegions;
        this.requestedRegions = requestedRegions;
        this.acceptedRegions = acceptedRegions;
        this.assessorId = assessorId;
        this.userClosed = userClosed;
        this.evidenceUrl = evidenceUrl;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public UUID getRequestId() {
        return requestId;
    }

    public DateTime getUpdateDate() {
        return updateDate;
    }

    public Set<Integer> getCurrentRegions() {
        return currentRegions;
    }

    public Set<Integer> getRequestedRegions() {
        return requestedRegions;
    }

    public Set<Integer> getAcceptedRegions() {
        return acceptedRegions;
    }

    public String getAssessorId() {
        return assessorId;
    }

    public HostRegionsModerationRequestStatus getStatus() {
        return status;
    }

    public boolean isUserClosed() {
        return userClosed;
    }

    public String getEvidenceUrl() {
        return evidenceUrl;
    }

    @Override
    public String toString() {
        return "HostRegionsModerationRequest{" +
                "hostId=" + hostId +
                ", requestId=" + requestId +
                ", updateDate=" + updateDate +
                ", status=" + status +
                ", currentRegions=" + currentRegions +
                ", requestedRegions=" + requestedRegions +
                ", acceptedRegions=" + acceptedRegions +
                ", assessorId='" + assessorId + '\'' +
                ", isUserClosedInfoBanner=" + userClosed +
                ", evidenceUrl='" + evidenceUrl + '\'' +
                '}';
    }
}
