package ru.yandex.webmaster3.storage.host.moderation.regions;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author leonidrom
 */
public enum HostRegionsModerationRequestStatus implements IntEnum {
    @Description("Заявка рассмотрена")
    MODERATED(0, true),
    @Description("Заявка рассматривается")
    IN_MODERATION(2, false),
    @Description("Заявка отменена пользователем")
    CANCELLED(3, true);

    private final int value;
    private final boolean finalState;

    HostRegionsModerationRequestStatus(int value, boolean finalState) {
        this.value = value;
        this.finalState = finalState;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isFinalState() {
        return finalState;
    }

    public static final IntEnumResolver<HostRegionsModerationRequestStatus> R = IntEnumResolver.r(HostRegionsModerationRequestStatus.class);
}
