package ru.yandex.webmaster3.storage.host.moderation.regions;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.host.moderation.AbstractHostModerationYtRequest;

import java.util.Set;
import java.util.UUID;

/**
 * @author leonidrom
 */

/**
 * Запрос на модерацию регионов для отгрузки в Yt
 */
public class HostRegionsModerationYtRequest extends AbstractHostModerationYtRequest {
    private final Set<Integer> currentRegions;
    private final Set<Integer> requestedRegions;
    private final Set<Integer> autoModeratedRegions;
    private final Set<Integer> needModerationRegions;
    private final String evidenceUrl;

    public HostRegionsModerationYtRequest(UUID requestId, WebmasterHostId hostId, DateTime createdDate,
                                          Set<Integer> currentRegions, Set<Integer> requestedRegions,
                                          Set<Integer> autoModeratedRegions, Set<Integer> needModerationRegions,
                                          String evidenceUrl) {
        super(requestId, hostId, createdDate);
        this.currentRegions = currentRegions;
        this.requestedRegions = requestedRegions;
        this.autoModeratedRegions = autoModeratedRegions;
        this.needModerationRegions = needModerationRegions;
        this.evidenceUrl = evidenceUrl;
    }

    public Set<Integer> getRequestedRegions() {
        return requestedRegions;
    }

    public String getEvidenceUrl() {
        return evidenceUrl;
    }

    public Set<Integer> getCurrentRegions() {
        return currentRegions;
    }

    public Set<Integer> getNeedModerationRegions() {
        return needModerationRegions;
    }

    public Set<Integer> getAutoModeratedRegions() {
        return autoModeratedRegions;
    }

    @Override
    public boolean isAutoModerated() {
        return needModerationRegions.isEmpty();
    }
}
