package ru.yandex.webmaster3.storage.host.moderation.regions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.storage.host.moderation.AbstractHostModerationYtResult;
import ru.yandex.webmaster3.storage.host.moderation.AbstractHostModerationYtService;
import ru.yandex.webmaster3.storage.host.moderation.regions.service.HostRegionsModerationYtService;

import java.util.Collections;
import java.util.List;

/**
 * @author leonidrom
 */

@JsonIgnoreProperties(ignoreUnknown = true)
public class HostRegionsModerationYtResult extends AbstractHostModerationYtResult {
    private final List<HostRegionsModerationYtService.YtRequestRegion> acceptedRegions;

    @JsonCreator
    public HostRegionsModerationYtResult(@JsonProperty("Host") String host,
                                         @JsonProperty("RequestId") String requestId,
                                         @JsonProperty("Assessor") String assessor,
                                         @JsonProperty("ModerationDate") String moderationDate,
                                         @JsonProperty("AcceptedRegions") List<HostRegionsModerationYtService.YtRequestRegion> acceptedRegions) {
        super(host, requestId, assessor, moderationDate);
        this.acceptedRegions = acceptedRegions;
    }

    @JsonIgnore
    public List<HostRegionsModerationYtService.YtRequestRegion> getAcceptedRegions() {
        return acceptedRegions;
    }
}
