package ru.yandex.webmaster3.storage.host.service;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.worker.client.WorkerClient;
import ru.yandex.webmaster3.core.worker.task.SyncVerificationStateTaskData;

/**
 * @author avhaliullin
 */
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class SyncVerificationStateService {
    private final WorkerClient workerClient;

    public void syncVerificationState(long userId, WebmasterHostId hostId) {
        workerClient.enqueueTask(new SyncVerificationStateTaskData(hostId, userId));
    }

}
