package ru.yandex.webmaster3.storage.hoststat.download;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;

import ru.yandex.webmaster3.storage.download.common.DownloadFileType;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;

/**
 * Created by Oleg Bazdyrev on 16/03/2021.
 */
@Getter
public class ContentAttrSamplesMdsExportDescriptor extends MdsExportDescriptor {

    private final ContentAttrType contentAttrType;
    private final String host;

    @JsonCreator
    public ContentAttrSamplesMdsExportDescriptor(@JsonProperty("contentAttrType") ContentAttrType contentAttrType,
                                                 @JsonProperty("host") String host) {
        super(DownloadFileType.CONTENT_ATTR_SAMPLES);
        this.contentAttrType = contentAttrType;
        this.host = host;
    }

    public enum ContentAttrType {
        TITLE,
        DESCRIPTION,
    }
}