package ru.yandex.webmaster3.storage.http.dao;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * Created by kravchenko99 on 08/02/2021.
 * <!-- Disabling actions: WMC-4134 -->
 */
@Repository
public class DisabledActionsPrefixesYDao extends AbstractYDao {

    private static final String TABLE_NAME = "disabled_actions_prefixes";

    public DisabledActionsPrefixesYDao() {
        super(PREFIX_INTERNAL, TABLE_NAME);
    }

    public List<String> getAllPrefixes() {
        return select(F.PREFIX).queryForList(Pair.of(F.PREFIX, x -> x));
    }

    private static class F {
        static final Field<String> PREFIX = Fields.stringField("action_prefix");
    }
}
