package ru.yandex.webmaster3.storage.iks.dao;

import org.joda.time.DateTime;

import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

import java.util.List;

/**
 * @author akhazhoyan 01/2019
 */
@Repository
public class IksUpdateDateYDao extends AbstractYDao {
    private static final String TABLE_NAME = "iks_update_date";

    public IksUpdateDateYDao() {
        super("/webmaster3/iks", TABLE_NAME);
    }

    public List<DateTime> iksUpdateDates() {
        return select(F.DATETIME)
                .queryForList();
    }

    public void insert(DateTime iksUpdateDate) {
        insert(F.DATETIME.value(iksUpdateDate)).execute();
    }

    private static class F {
        static final Field<DateTime> DATETIME = Fields.jodaDateTimeField("update_date");

    }
}

