package ru.yandex.webmaster3.storage.importanturls.dao;

import java.util.Map;
import java.util.Optional;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.W3Collectors;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;


/**
 * Created by Oleg Bazdyrev on 2019-06-17.
 */
@Slf4j
@Repository
public class ImportantUrlsLimitYDao extends AbstractYDao {

    public ImportantUrlsLimitYDao() {
        super(PREFIX_IMPORTANT_URLS, "important_urls_limit");
    }
    private static final Object KEY = new Object();

    private final LoadingCache<Object, Map<WebmasterHostId, Integer>> mainMirrorsCache =
            CacheBuilder.newBuilder()
                    .build(CacheLoader.from(this::getLimits));

    // в этой табилце хранятся только яндексовые сервисы около 10
    public Optional<Integer> getLimit(WebmasterHostId hostId) {
        return Optional.ofNullable(mainMirrorsCache.getUnchecked(KEY).get(hostId));
    }

    public Map<WebmasterHostId, Integer> getLimits() {
        return select(MAPPER).queryForList().stream().collect(W3Collectors.toHashMap());
    }

    private static final DataMapper<Pair<WebmasterHostId, Integer>> MAPPER = DataMapper.create(
            F.HOST_ID, F.VALUE, Pair::of
    );

    private interface F {
        Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
        Field<Integer> VALUE = Fields.intField("value");
    }
}
