package ru.yandex.webmaster3.storage.importanturls.dao;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.sitestructure.RawSearchUrlStatusEnum;
import ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusEnum;
import ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusUtil;
import ru.yandex.webmaster3.storage.importanturls.data.ImportantUrlStatus;
import ru.yandex.webmaster3.storage.searchurl.samples.data.UrlStatusInfo;
import ru.yandex.webmaster3.core.util.http.YandexMimeType;
import ru.yandex.wmtools.common.util.http.YandexHttpStatus;

/**
 * @author avhaliullin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ImportantUrlsRecord {

    @JsonProperty("AddTime")
    private final long addTime;
    @JsonProperty("BeautyUrl")
    private final String beautyUrl;
    @JsonProperty("Description")
    private final String description;
    @JsonProperty("Host")
    private final String host;
    @JsonProperty("HttpCode")
    private final Integer httpCode;
    @JsonProperty("IsFake")
    private final Boolean isFake;
    @JsonProperty("IsIndexed")
    private final Boolean isIndexed;
    @JsonProperty("IsSearchable")
    private final Boolean isSearchable;
    @JsonProperty("JupiterTimestamp")
    private final Long jupiterTimestamp;
    @JsonProperty("LastAccess")
    private final Long lastAccess;
    @JsonProperty("MainHost")
    private final String mainHost;
    @JsonProperty("MainMirrorHost")
    private final String mainMirrorHost;
    @JsonProperty("MainPath")
    private final String mainPath;
    @JsonProperty("MimeType")
    private final Integer mimeType;
    @JsonProperty("Path")
    private final String path;
    @JsonProperty("RedirTarget")
    private final String redirTarget;
    @JsonProperty("RelCanonicalTarget")
    private final String relCanonicalTarget;
    @JsonProperty("SpreadHttpCode")
    private final Integer spreadHttpCode;
    @JsonProperty("SpreadLastAccess")
    private final Long spreadLastAccess;
    @JsonProperty("SpreadMimeType")
    private final Integer spreadMimeType;
    @JsonProperty("TableTimestamp")
    private final Long tableTimestamp;
    @JsonProperty("Title")
    private final String title;
    @JsonProperty("UrlStatus")
    private final Integer urlStatus;

    @JsonCreator
    public ImportantUrlsRecord(long addTime, String beautyUrl, String description, String host, Integer httpCode,
                               Boolean isFake, Boolean isIndexed, Boolean isSearchable, Long jupiterTimestamp,
                               Long lastAccess, String mainHost, String mainMirrorHost, String mainPath,
                               Integer mimeType, String path, String redirTarget,
                               String relCanonicalTarget, Integer spreadHttpCode,
                               Long spreadLastAccess, Integer spreadMimeType, Long tableTimestamp,
                               String title, Integer urlStatus) {
        this.addTime = addTime;
        this.beautyUrl = beautyUrl;
        this.description = description;
        this.host = host;
        this.httpCode = httpCode;
        this.isFake = isFake;
        this.isIndexed = isIndexed;
        this.isSearchable = isSearchable;
        this.jupiterTimestamp = jupiterTimestamp;
        this.lastAccess = lastAccess;
        this.mainHost = mainHost;
        this.mainMirrorHost = mainMirrorHost;
        this.mainPath = mainPath;
        this.mimeType = mimeType;
        this.path = path;
        this.redirTarget = redirTarget;
        this.relCanonicalTarget = relCanonicalTarget;
        this.spreadHttpCode = spreadHttpCode;
        this.spreadLastAccess = spreadLastAccess;
        this.spreadMimeType = spreadMimeType;
        this.tableTimestamp = tableTimestamp;
        this.title = title;
        this.urlStatus = urlStatus;
    }

    public long getAddTime() {
        return addTime;
    }

    public String getBeautyUrl() {
        return beautyUrl;
    }

    public String getDescription() {
        return description;
    }

    public String getHost() {
        return host;
    }

    public Integer getHttpCode() {
        return httpCode;
    }

    public Boolean getFake() {
        return isFake;
    }

    public Boolean getIndexed() {
        return isIndexed;
    }

    public Boolean getSearchable() {
        return isSearchable;
    }

    public Long getJupiterTimestamp() {
        return jupiterTimestamp;
    }

    public Long getLastAccess() {
        return lastAccess;
    }

    public String getMainHost() {
        return mainHost;
    }

    public String getMainMirrorHost() {
        return mainMirrorHost;
    }

    public String getMainPath() {
        return mainPath;
    }

    public Integer getMimeType() {
        return mimeType;
    }

    public String getPath() {
        return path;
    }

    public String getRedirTarget() {
        return redirTarget;
    }

    public String getRelCanonicalTarget() {
        return relCanonicalTarget;
    }

    public Integer getSpreadHttpCode() {
        return spreadHttpCode;
    }

    public Long getSpreadLastAccess() {
        return spreadLastAccess;
    }

    public Integer getSpreadMimeType() {
        return spreadMimeType;
    }

    public Long getTableTimestamp() {
        return tableTimestamp;
    }

    public String getTitle() {
        return title;
    }

    public Integer getUrlStatus() {
        return urlStatus;
    }

    @JsonIgnore
    public ImportantUrlStatus.SearchInfo toSearchInfo() {

        final DateTime lastAccess;
        if (this.lastAccess != null && this.lastAccess != 0) {
            lastAccess = new DateTime(this.lastAccess * 1000L);
        } else if (spreadLastAccess != null) {
            lastAccess = new DateTime(this.spreadLastAccess * 1000L);
        } else {
            lastAccess = new DateTime(0);
        }


        final RawSearchUrlStatusEnum rawStatus =
                Optional.ofNullable(urlStatus).map(RawSearchUrlStatusEnum.R::fromValue).orElse(RawSearchUrlStatusEnum.NOTHING_FOUND);
        SearchUrlStatusEnum status = SearchUrlStatusUtil.raw2View(rawStatus, Boolean.TRUE.equals(isSearchable));
        final Integer httpCode = ObjectUtils.firstNonNull(this.httpCode, this.spreadHttpCode, YandexHttpStatus.UNKNOWN.getCode());

        final UrlStatusInfo statusInfo = new UrlStatusInfo(status, new DateTime(addTime * 1000L), beautyUrl, httpCode,
                mainHost, mainPath, redirTarget, relCanonicalTarget, description,
                false, false, false, false, false);
        YandexMimeType mimeType = this.mimeType == null ? null : YandexMimeType.R.fromValueOrUnknown(this.mimeType);
        return new ImportantUrlStatus.SearchInfo(httpCode, lastAccess, mimeType, statusInfo);
    }
}
