package ru.yandex.webmaster3.storage.importanturls.dao;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.HttpCodeInfo;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.importanturls.data.ImportantUrlChange;

/**
 * Created by Oleg Bazdyrev on 2019-06-06.
 */
public class ImportantUrlsRecordPair {

    public static final TypeReference<List<ImportantUrlsRecordPair>> LIST_TYPE_REFERENCE =
            new TypeReference<List<ImportantUrlsRecordPair>>() {
            };

    @JsonProperty("Current")
    private final ImportantUrlsRecord current;
    @JsonProperty("Previous")
    private final ImportantUrlsRecord previous;

    @JsonCreator
    public ImportantUrlsRecordPair(ImportantUrlsRecord current, ImportantUrlsRecord previous) {
        this.current = current;
        this.previous = previous;
    }

    public ImportantUrlsRecord getCurrent() {
        return current;
    }

    public ImportantUrlsRecord getPrevious() {
        return previous;
    }

    public ImportantUrlChange.TitleChange titleChange() {
        return new ImportantUrlChange.TitleChange(
                IdUtils.urlToHostId(current.getHost()), current.getPath(), previous.getTitle(), current.getTitle());
    }

    public ImportantUrlChange.IndexingLastAccessChange indexingLastAccessChange() {
        return new ImportantUrlChange.IndexingLastAccessChange(IdUtils.urlToHostId(current.getHost()), current.getPath(),
                secondsToDateTime(previous.getSpreadLastAccess()),
                secondsToDateTime(current.getSpreadLastAccess()));
    }

    public ImportantUrlChange.HttpCodeChange httpCodeChange() {
        return new ImportantUrlChange.HttpCodeChange(IdUtils.urlToHostId(current.getHost()), current.getPath(),
                new HttpCodeInfo(previous.getSpreadHttpCode()),
                new HttpCodeInfo(current.getSpreadHttpCode()));
    }

    public ImportantUrlChange.SearchLastAccessChange searchLastAccessChange() {
        return new ImportantUrlChange.SearchLastAccessChange(IdUtils.urlToHostId(current.getHost()), current.getPath(),
                secondsToDateTime(previous.getLastAccess()),
                secondsToDateTime(current.getLastAccess()));
    }

    private DateTime secondsToDateTime(Long timeSeconds) {
        if (timeSeconds == null || timeSeconds == 0L) {
            return null;
        }

        return new DateTime(timeSeconds * 1000L);
    }

    public ImportantUrlChange.SearchUrlStatusChange searchUrlStatusChange() {
        return new ImportantUrlChange.SearchUrlStatusChange(IdUtils.urlToHostId(current.getHost()), current.getPath(),
                previous.toSearchInfo(), current.toSearchInfo());
    }

    public ImportantUrlChange.DescriptionChange descriptionChange() {
        return new ImportantUrlChange.DescriptionChange(IdUtils.urlToHostId(current.getHost()), current.getPath(),
                previous.getDescription(), current.getDescription());
    }

    public ImportantUrlChange.RelCanonicalTargetChange relCanonicalTargetChange() {
        return new ImportantUrlChange.RelCanonicalTargetChange(IdUtils.urlToHostId(current.getHost()), current.getPath(),
                previous.getRelCanonicalTarget(), current.getRelCanonicalTarget());
    }
}
