package ru.yandex.webmaster3.storage.importanturls.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusEnum;
import ru.yandex.webmaster3.core.util.http.YandexMimeType;

/**
 * @author avhaliullin
 */
public class ImportantUrlSearchRawInfo {
    private final WebmasterHostId hostId;
    private final String relUrl;
    private final String title;
    private final Instant jupiterTimestamp;
    private final DateTime lastAccess;
    private final YandexMimeType mimeType;
    private final SearchUrlStatusEnum status;
    private final Boolean fake;
    private final String region;
    private final DateTime addTime;
    private final String beautyUrl;
    private final Integer httpCode;
    private final String mainHost;
    private final String mainPath;
    private final String mainRegion;
    private final String redirectTarget;
    private final String relCanonicalTarget;
    private final String description;

    @JsonCreator
    public ImportantUrlSearchRawInfo(WebmasterHostId hostId, String relUrl, String title, Instant jupiterTimestamp,
                                     DateTime lastAccess, YandexMimeType mimeType, SearchUrlStatusEnum status,
                                     Boolean fake, String region, DateTime addTime, String beautyUrl, Integer httpCode,
                                     String mainHost, String mainPath, String mainRegion, String redirectTarget,
                                     String relCanonicalTarget, String description) {
        this.hostId = hostId;
        this.relUrl = relUrl;
        this.title = title;
        this.jupiterTimestamp = jupiterTimestamp;
        this.lastAccess = lastAccess;
        this.mimeType = mimeType;
        this.status = status;
        this.fake = fake;
        this.region = region;
        this.addTime = addTime;
        this.beautyUrl = beautyUrl;
        this.httpCode = httpCode;
        this.mainHost = mainHost;
        this.mainPath = mainPath;
        this.mainRegion = mainRegion;
        this.redirectTarget = redirectTarget;
        this.relCanonicalTarget = relCanonicalTarget;
        this.description = description;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public String getRelUrl() {
        return relUrl;
    }

    public String getTitle() {
        return title;
    }

    public Instant getJupiterTimestamp() {
        return jupiterTimestamp;
    }

    public DateTime getLastAccess() {
        return lastAccess;
    }

    public YandexMimeType getMimeType() {
        return mimeType;
    }

    public SearchUrlStatusEnum getStatus() {
        return status;
    }

    public Boolean getFake() {
        return fake;
    }

    public String getRegion() {
        return region;
    }

    public DateTime getAddTime() {
        return addTime;
    }

    public String getBeautyUrl() {
        return beautyUrl;
    }

    public Integer getHttpCode() {
        return httpCode;
    }

    public String getMainHost() {
        return mainHost;
    }

    public String getMainPath() {
        return mainPath;
    }

    public String getMainRegion() {
        return mainRegion;
    }

    public String getRedirectTarget() {
        return redirectTarget;
    }

    public String getRelCanonicalTarget() {
        return relCanonicalTarget;
    }

    public String getDescription() {
        return description;
    }
}
