package ru.yandex.webmaster3.storage.importer.model.clear;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

import ru.yandex.webmaster3.storage.importer.model.ImportContext;
import ru.yandex.webmaster3.storage.importer.model.ImportTask;

/**
 * Created by Oleg Bazdyrev on 01/10/2020.
 */
@Value
@AllArgsConstructor(onConstructor_ = @JsonCreator)
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class ImportClearNone implements ImportClearPolicy {

    @Override
    public ImportTask apply(ImportContext context) {
        return context.getTask().withNextStage().build();
    }

    @Override
    public ImportClearType getType() {
        return ImportClearType.NONE;
    }
}
