package ru.yandex.webmaster3.storage.importer.model.init;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.storage.util.yt.YtPath;
import ru.yandex.webmaster3.storage.importer.model.ImportContext;
import ru.yandex.webmaster3.storage.importer.model.ImportStage;
import ru.yandex.webmaster3.storage.importer.model.ImportTask;

/**
 * Created by Oleg Bazdyrev on 20/09/2020.
 */
@Value
@AllArgsConstructor(onConstructor_ = @JsonCreator)
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class ImportInitByModificationDate implements ImportInitPolicy {

    YtPath path;

    @Override
    public ImportInitType getType() {
        return ImportInitType.BY_MODIFICATION_DATE;
    }

    @Override
    public String getCluster() {
        return path.getCluster();
    }

    @Override
    public ImportTask apply(ImportContext context) {
        ImportTask task = context.getTask();
        long updateTime = context.getCypressService().getNode(path).getUpdateTime().getMillis();
        Long prevUpdateTime = task.getPrevData(ImportStage.INIT, Data.class).map(Data::getDate).orElse(null);

        if (prevUpdateTime == null || updateTime > prevUpdateTime) {
            return task.withNextStage().started(DateTime.now()).data(task.putData(ImportStage.INIT, new Data(updateTime))).sourceTable(path).build();
        } else {
            return task.updateStage(ImportStage.DONE).build();
        }
    }

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    private static final class Data {
        long date;
    }
}
