package ru.yandex.webmaster3.storage.importer.model.init;

import lombok.AllArgsConstructor;

import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;

/**
 * Created by Oleg Bazdyrev on 21/09/2020.
 */
@AllArgsConstructor
public enum ImportInitType implements Discriminator<ImportInitPolicy> {
    BY_MODIFICATION_DATE(ImportInitByModificationDate.class),
    BY_DATE_IN_NAME(ImportInitByDateInName.class),
    BY_DATE_RANGE_IN_ATTRIBUTE(ImportInitByDateRangeInAttribute.class),
    TAIL_AND_WEEK_TABLES(ImportInitTailAndWeekTables.class),
    ;

    private final Class<? extends ImportInitPolicy> dataClass;

    @Override
    public Class<? extends ImportInitPolicy> getDataClass() {
        return dataClass;
    }
}
