package ru.yandex.webmaster3.storage.importer.model.preprocess;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.webmaster3.storage.importer.model.ImportContext;
import ru.yandex.webmaster3.storage.importer.model.ImportTask;

/**
 * Created by Oleg Bazdyrev on 30/09/2020.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ImportPreprocessNone implements ImportPreprocessPolicy {

    @Override
    public ImportPreprocessType getType() {
        return ImportPreprocessType.NONE;
    }

    @Override
    public ImportTask apply(ImportContext context) {
        return context.getTask().withNextStage().intermediateTable(context.getTask().getSourceTable()).build();
    }


}
