package ru.yandex.webmaster3.storage.importer.model.preprocess;

import lombok.AllArgsConstructor;

import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;

/**
 * Created by Oleg Bazdyrev on 25/09/2020.
 */
@AllArgsConstructor
public enum ImportPreprocessType implements Discriminator<ImportPreprocessPolicy> {
    RENAME_COLUMNS(ImportPreprocessRenameColumns.class),
    NONE(ImportPreprocessNone.class),
    YQL_QUERY(ImportPreprocessYqlQuery.class),
    ;

    private final Class<? extends ImportPreprocessPolicy> dataClass;

    @Override
    public Class<? extends ImportPreprocessPolicy> getDataClass() {
        return dataClass;
    }
}
