package ru.yandex.webmaster3.storage.importer.model.switching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

import ru.yandex.webmaster3.storage.importer.model.ImportContext;
import ru.yandex.webmaster3.storage.importer.model.ImportTask;
import ru.yandex.webmaster3.storage.importer.model.MdbClickhouseTableInfo;

/**
 * Created by Oleg Bazdyrev on 30/09/2020.
 */
@Value
@AllArgsConstructor(onConstructor_ = @JsonCreator)
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class ImportSwitchImmediate implements ImportSwitchPolicy {

    @Override
    public ImportSwitchType getType() {
        return ImportSwitchType.IMMEDIATE;
    }

    @Override
    public ImportTask apply(ImportContext context) {
        // take last table with id and set state
        ImportTask task = context.getTask();
        // save table info
        context.getClickhouseTablesYDao().update(MdbClickhouseTableInfo.fromContext(context).build());
        return task.withNextStage().build();
    }



}
