package ru.yandex.webmaster3.storage.importer.model.switching;

import java.time.format.DateTimeFormatter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

import ru.yandex.webmaster3.storage.importer.model.ImportContext;
import ru.yandex.webmaster3.storage.importer.model.ImportTask;

/**
 * Created by Oleg Bazdyrev on 08/10/2020.
 * Мержит исторические данные в единую таблицу (с задержкой или без)
 */
@Value
@AllArgsConstructor(onConstructor_ = @JsonCreator)
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class ImportSwitchMergeTables implements ImportSwitchPolicy {

    String mergeTableNamePattern;
    String sourceTableNamePattern;
    DateTimeFormatter dtf;

    @Override
    public ImportTask apply(ImportContext context) {
        return null;
    }

    @Override
    public ImportSwitchType getType() {
        return ImportSwitchType.MERGE_TABLES;
    }

    public enum MergePeriod {
        MONTH,
        YEAR,
        INFINITY
    }
}
