package ru.yandex.webmaster3.storage.importer.model.switching;

import lombok.AllArgsConstructor;

import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;

/**
 * Created by Oleg Bazdyrev on 30/09/2020.
 */
@AllArgsConstructor
public enum ImportSwitchType implements Discriminator<ImportSwitchPolicy> {
    IMMEDIATE(ImportSwitchImmediate.class),
    MERGE_TABLES(ImportSwitchMergeTables.class),
    SEARCH_QUERIES(ImportSwitchSearchQueries.class),
    REPLACE_TAIL_AND_WEEK(ImportSwitchReplaceTailAndWeek.class),
    ;

    private final Class<? extends ImportSwitchPolicy> dataClass;

    @Override
    public Class<? extends ImportSwitchPolicy> getDataClass() {
        return dataClass;
    }
}
