package ru.yandex.webmaster3.storage.indexing2.download;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.storage.download.DownloadTaskData;
import ru.yandex.webmaster3.storage.indexing2.samples.dao.IndexingEventsOrderField;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;

import java.util.UUID;

/**
 * Created by ifilippov5 on 28.02.17.
 */
public class DownloadIndexingUrlEventSamplesTaskData extends DownloadTaskData<IndexedUrlEventSampleCsvRow> {
    private final Condition filters;
    private IndexingEventsOrderField orderBy;
    private final OrderDirection orderDirection;

    public DownloadIndexingUrlEventSamplesTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("filters") Condition filters,
            @JsonProperty("orderBy") IndexingEventsOrderField orderBy,
            @JsonProperty("orderDirection") OrderDirection orderDirection,
            @JsonProperty("exportFormat") FileFormat exportFormat,
            @JsonProperty("fileName") String fileName,
            @JsonProperty("hash") Long hash) {
        super(taskId, hostId, null, exportFormat, fileName, hash, IndexedUrlEventSampleCsvRow.class);
        this.filters = filters;
        this.orderBy = orderBy;
        this.orderDirection = orderDirection;
    }

    private DownloadIndexingUrlEventSamplesTaskData(WebmasterHostId hostId, Condition filters,
                                                    IndexingEventsOrderField orderBy, OrderDirection orderDirection,
                                                    FileFormat exportFormat, String fileName, Long hash) {
        super(hostId, null, exportFormat, fileName, hash, IndexedUrlEventSampleCsvRow.class);
        this.filters = filters;
        this.orderBy = orderBy;
        this.orderDirection = orderDirection;
    }

    public static WorkerTaskData createTaskData(WebmasterHostId hostId, Condition filters,
                                                IndexingEventsOrderField orderBy, OrderDirection orderDirection,
                                                FileFormat exportFormat, String fileName, Long hash) {
        return new DownloadIndexingUrlEventSamplesTaskData(hostId, filters, orderBy, orderDirection, exportFormat, fileName, hash);
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.DOWNLOAD_INDEXED_URL_EVENT_SAMPLES;
    }

    @Override
    public String getShortDescription() {
        return "Download indexed url event samples";
    }

    public Condition getFilters() {
        return filters;
    }

    public IndexingEventsOrderField getOrderBy() {
        return orderBy;
    }

    public OrderDirection getOrderDirection() {
        return orderDirection;
    }
}
