package ru.yandex.webmaster3.storage.indexing2.download;

import ru.yandex.webmaster3.core.xcelite.annotations.Column;
import ru.yandex.webmaster3.core.xcelite.annotations.Row;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.opencsv.bean.CsvBindByName;
import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by ifilippov5 on 28.02.17.
 */
@Row(colsOrder = {"url", "currentHttpCode", "prevHttpCode", "lastAccess"})
public class IndexedUrlEventSampleCsvRow {
    @CsvBindByName
    @Column
    private final String url;

    @CsvBindByName
    @Column
    private final String currentHttpCode;

    @CsvBindByName
    @Column
    private final String prevHttpCode;

    @CsvBindByName
    @Column
    private final String lastAccess;

    public IndexedUrlEventSampleCsvRow(@JsonProperty("url") String url,
                                       @JsonProperty("currentHttpCode") String currentHttpCode,
                                       @JsonProperty("prevHttpCode") String prevHttpCode,
                                       @JsonProperty("lastAccess") String lastAccess) {
        this.url = url;
        this.lastAccess = lastAccess;
        this.currentHttpCode = currentHttpCode;
        this.prevHttpCode = prevHttpCode;
    }

    @Description("адрес страницы")
    public String getUrl() {
        return url;
    }

    @Description("дата последнего посещения страницы")
    public String getLastAccess() {
        return lastAccess;
    }

    public String getCurrentHttpCode() {
        return currentHttpCode;
    }

    public String getPrevHttpCode() {
        return prevHttpCode;
    }
}
