package ru.yandex.webmaster3.storage.indexing2.download;

import ru.yandex.webmaster3.core.xcelite.annotations.Column;
import ru.yandex.webmaster3.core.xcelite.annotations.Row;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.opencsv.bean.CsvBindByName;
import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by ifilippov5 on 28.02.17.
 */
@Row(colsOrder = {"url", "currentHttpCode", "lastAccess"})
public class IndexedUrlSampleCsvRow {
    @CsvBindByName
    @Column
    private final String url;

    @CsvBindByName
    @Column
    private final String currentHttpCode;

    @CsvBindByName
    @Column
    private final String lastAccess;

    public IndexedUrlSampleCsvRow(@JsonProperty("url") String url,
                                       @JsonProperty("currentHttpCode") String currentHttpCode,
                                       @JsonProperty("lastAccess") String lastAccess) {
        this.url = url;
        this.lastAccess = lastAccess;
        this.currentHttpCode = currentHttpCode;
    }

    @Description("адрес страницы")
    public String getUrl() {
        return url;
    }

    @Description("дата последнего посещения страницы")
    public String getLastAccess() {
        return lastAccess;
    }

    public String getCurrentHttpCode() {
        return currentHttpCode;
    }
}
