package ru.yandex.webmaster3.storage.indexing2.history.data;

import org.joda.time.Instant;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * Created by leonidrom on 21/02/2017.
 */
public final class IndexedUrlsCountHistoryRecord {
    private final WebmasterHostId hostId;
    private final long nodeId;
    private final Instant timestamp;
    private final int status;
    private final long value;

    public IndexedUrlsCountHistoryRecord(WebmasterHostId hostId, long nodeId,
                                         Instant timestamp, int status, long value) {
        this.hostId = hostId;
        this.nodeId = nodeId;
        this.timestamp = timestamp;
        this.status = status;
        this.value = value;
    }

    public long getNodeId() {
        return nodeId;
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    public int getStatus() {
        return status;
    }

    public long getValue() {
        return value;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }
}
