package ru.yandex.webmaster3.storage.indexing2.history.data;

import org.joda.time.Instant;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class IndexingEventsCountHistoryRecord {
    private final WebmasterHostId hostId;
    private final long nodeId;
    private final Instant timestamp;
    private final long countNew;
    private final long countChanged;

    public IndexingEventsCountHistoryRecord(WebmasterHostId hostId, long nodeId, Instant timestamp, long countNew, long countChanged) {
        this.hostId = hostId;
        this.nodeId = nodeId;
        this.timestamp = timestamp;
        this.countNew = countNew;
        this.countChanged = countChanged;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public long getNodeId() {
        return nodeId;
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    public long getCountNew() {
        return countNew;
    }

    public long getCountChanged() {
        return countChanged;
    }
}
