package ru.yandex.webmaster3.storage.indexing2.internal.data;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author avhaliullin
 */
public enum IndexingHistoryTableImportState {
    PREPARING(false),
    IMPORTING(false),
    REPLICATING(false),
    RENAMING(false),
    CLEANING(false),
    DONE(true),
    FAILED(true),
    ;

    private final boolean terminal;

    IndexingHistoryTableImportState(boolean terminal) {
        this.terminal = terminal;
    }

    public boolean isTerminal() {
        return terminal;
    }

    public static IndexingHistoryTableImportState INIT = PREPARING;

    public static EnumResolver<IndexingHistoryTableImportState> R = EnumResolver.er(IndexingHistoryTableImportState.class);
}
