package ru.yandex.webmaster3.storage.indexing2.internal.data;

import org.joda.time.Instant;
import org.joda.time.LocalDate;
import ru.yandex.webmaster3.storage.util.yt.YtPath;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public class IndexingSamplesTableInfo {
    private final IndexingSamplesImportType importType;
    private final LocalDate tableDate;
    private final boolean tail;
    private final Instant updateTime;
    private final Set<LocalDate> replacingCHTables;
    private final YtPath sourceYtPath;
    private final IndexingSamplesTableState state;
    private final List<YtPath> preparedYtTables;
    private final UUID importManagerTaskId;
    private final UUID replicationManagerTaskId;
    private final String tmpTableName;

    public IndexingSamplesTableInfo(IndexingSamplesImportType importType, LocalDate tableDate, boolean tail, Instant updateTime, Set<LocalDate> replacingCHTables, YtPath sourceYtPath, IndexingSamplesTableState state, List<YtPath> preparedYtTables, UUID importManagerTaskId, UUID replicationManagerTaskId, String tmpTableName) {
        this.importType = importType;
        this.tableDate = tableDate;
        this.tail = tail;
        this.updateTime = updateTime;
        this.replacingCHTables = replacingCHTables;
        this.sourceYtPath = sourceYtPath;
        this.state = state;
        this.preparedYtTables = preparedYtTables;
        this.importManagerTaskId = importManagerTaskId;
        this.replicationManagerTaskId = replicationManagerTaskId;
        this.tmpTableName = tmpTableName;
    }

    public IndexingSamplesImportType getImportType() {
        return importType;
    }

    public LocalDate getTableDate() {
        return tableDate;
    }

    public boolean isTail() {
        return tail;
    }

    public Instant getUpdateTime() {
        return updateTime;
    }

    public Set<LocalDate> getReplacingCHTables() {
        return replacingCHTables;
    }

    public YtPath getSourceYtPath() {
        return sourceYtPath;
    }

    public IndexingSamplesTableState getState() {
        return state;
    }

    public List<YtPath> getPreparedYtTables() {
        return preparedYtTables;
    }

    public UUID getImportManagerTaskId() {
        return importManagerTaskId;
    }

    public UUID getReplicationManagerTaskId() {
        return replicationManagerTaskId;
    }

    public String getTmpTableName() {
        return tmpTableName;
    }

    public IndexingSamplesTableInfo withState(IndexingSamplesTableState state) {
        return new IndexingSamplesTableInfo(importType, tableDate, tail, updateTime, replacingCHTables, sourceYtPath, state, preparedYtTables, importManagerTaskId, replicationManagerTaskId, tmpTableName);
    }

    public IndexingSamplesTableInfo withPreparedTables(List<YtPath> preparedTables) {
        return new IndexingSamplesTableInfo(importType, tableDate, tail, updateTime, replacingCHTables, sourceYtPath, state, preparedTables, importManagerTaskId, replicationManagerTaskId, tmpTableName);
    }

    public IndexingSamplesTableInfo failed() {
        return withState(IndexingSamplesTableState.FAILED);
    }

    public IndexingSamplesTableInfo withImportManagerTaskId(UUID importManagerTaskId) {
        return new IndexingSamplesTableInfo(importType, tableDate, tail, updateTime, replacingCHTables, sourceYtPath, state, preparedYtTables, importManagerTaskId, replicationManagerTaskId, tmpTableName);
    }

    public IndexingSamplesTableInfo withTmpTable(String tmpTableName) {
        return new IndexingSamplesTableInfo(importType, tableDate, tail, updateTime, replacingCHTables, sourceYtPath, state, preparedYtTables, importManagerTaskId, replicationManagerTaskId, tmpTableName);
    }

    public IndexingSamplesTableInfo withReplicationManagerTaskId(UUID replicationManagerTaskId){
        return new IndexingSamplesTableInfo(importType, tableDate, tail, updateTime, replacingCHTables, sourceYtPath, state, preparedYtTables, importManagerTaskId, replicationManagerTaskId, tmpTableName);
    }

    public static final Comparator<IndexingSamplesTableInfo> BY_TABLE_DATE_AND_UPDATE_TIME = Comparator
            .comparing(IndexingSamplesTableInfo::getTableDate)
            .thenComparing(IndexingSamplesTableInfo::getUpdateTime);

}
