package ru.yandex.webmaster3.storage.indexing2.internal.data;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author avhaliullin
 */
public enum IndexingSamplesTableState {
    PREPARING(false),
    IMPORTING(false),
    REPLICATING(false),
    REPLACING(false),
    CLEANUP(false),
    DONE(true),
    FAILED(true),
    ;

    private final boolean terminal;

    IndexingSamplesTableState(boolean terminal) {
        this.terminal = terminal;
    }

    public boolean isTerminal() {
        return terminal;
    }

    public static final EnumResolver<IndexingSamplesTableState> R = EnumResolver.er(IndexingSamplesTableState.class);
}
