package ru.yandex.webmaster3.storage.indexing2.samples;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import ru.yandex.webmaster3.core.util.TimeUtils;

/**
 * В связи с тем, что данные для графика агрегируются по UTC, приходится вводить костыль, который перемапливает
 * даты в примерах урлов - чтобы не было неконсистентности между примерами и числами на графике.
 *
 * @author avhaliullin
 */
public class IndexingTimeZoneWorkaround {
    public static DateTime dbDatetime2User(DateTime dbTime) {
        return dbTime
                .withZone(DateTimeZone.UTC)
                .toLocalDateTime()
                .toDateTime(TimeUtils.EUROPE_MOSCOW_ZONE);
    }

    public static DateTime userDatetime2DB(DateTime userTime) {
        //Нужно не просто отбросить зону - а использовать правильное смещение конкретно между MSK и UTC
        return userTime
                .withZone(TimeUtils.EUROPE_MOSCOW_ZONE)// явно приводим к MSK, абсолютное время сохраняется
                .toLocalDateTime() // теряем информацию о зоне и абсолютном времени, остается просто что-то вида 2017-01-01 00:00:00
                .toDateTime(DateTimeZone.UTC); // и интерпретируем эту строку как время в UTC
    }
}
