package ru.yandex.webmaster3.storage.indexing2.samples.dao;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.codes.HttpCodeGroup;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.*;
import ru.yandex.wmtools.common.util.http.YandexHttpStatus;

/**
 * Created by leonidrom on 27/02/2017.
 */
public class IndexedUrlSampleConditions {
    public static Condition lastAccessCondition(Operator op, DateTime value) {
        return new JavaTimestampCondition(IndexedUrlSampleCHDao.F.LAST_ACCESS, op, value);
    }

    public static Condition pathContains(String value) {
        return new TextContainsCondition(IndexedUrlSampleCHDao.F.PATH, value);
    }

    public static Condition codeEqual(HttpCodeGroup codeGroup) {
        return new IntInCondition(IndexedUrlSampleCHDao.F.HTTP_CODE, codeGroup.getCodesInternal());
    }

    // TODO: for backward compatibility until frontend migrates to the new filters
    public static Condition codeEqual(YandexHttpStatus code) {
        return new IntEqualCondition(IndexedUrlSampleCHDao.F.HTTP_CODE, code.value());
    }

    public static TextLikeCondition buildPathCondition(TextLikeCondition.Builder builder) {
        return builder.build(IndexingEventSamplesCHDao.F.PATH);
    }

    public static String getUrlFieldName() {
        return IndexedUrlSampleCHDao.F.PATH;
    }
}
