package ru.yandex.webmaster3.storage.indexing2.samples.dao;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.codes.HttpCodeGroup;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.*;
import ru.yandex.wmtools.common.util.http.YandexHttpStatus;

/**
 * @author avhaliullin
 */
public class IndexingEventConditions {
    public static Condition lastAccessCondition(Operator op, DateTime value) {
        return new JavaTimestampCondition(IndexingEventSamplesCHDao.F.LAST_ACCESS, op, value);
    }

    public static Condition pathContains(String value) {
        return new TextContainsCondition(IndexingEventSamplesCHDao.F.PATH, value);
    }

    public static Condition curCodeEqual(HttpCodeGroup codeGroup) {
        return new IntInCondition(IndexingEventSamplesCHDao.F.CUR_HTTP_CODE, codeGroup.getCodesInternal());
    }

    // TODO: for backward compatibility until frontend migrates to the new filters
    public static Condition curCodeEqual(YandexHttpStatus code) {
        return new IntEqualCondition(IndexingEventSamplesCHDao.F.CUR_HTTP_CODE, code.value());
    }

    public static Condition prevCodeEqual(HttpCodeGroup codeGroup) {
        if (codeGroup == HttpCodeGroup.NEVER_DOWNLOADED) {
            return Condition.or(
                    // На сегодняшний момент (30.03.2017) для страниц ни разу не обойденных роботом
                    // в базе хранится http код -1, что соответствует YandexHttpStatus.UNKNOWN.
                    // Это не очень красиво, поэтому есть желание начать хранить специальный код
                    // YandexHttpStatus.NEVER_DOWNLOADED.
                    // Что бы при этом не сломались фильтры, мы здесь сравниваем оба значения.
                    new IntEqualCondition(IndexingEventSamplesCHDao.F.PREV_HTTP_CODE, YandexHttpStatus.NEVER_DOWNLOADED.value()),
                    new IntEqualCondition(IndexingEventSamplesCHDao.F.PREV_HTTP_CODE, YandexHttpStatus.UNKNOWN.value())
            );
        } else {
            return new IntInCondition(IndexingEventSamplesCHDao.F.PREV_HTTP_CODE, codeGroup.getCodesInternal());
        }
    }

    // TODO: for backward compatibility until frontend migrates to the new filters
    public static Condition prevCodeEqual(YandexHttpStatus code) {
        if (code == YandexHttpStatus.NEVER_DOWNLOADED) {
            return Condition.or(
                    new IntEqualCondition(IndexingEventSamplesCHDao.F.PREV_HTTP_CODE, YandexHttpStatus.NEVER_DOWNLOADED.value()),
                    new IntEqualCondition(IndexingEventSamplesCHDao.F.PREV_HTTP_CODE, YandexHttpStatus.UNKNOWN.value())
            );
        }
        return new IntEqualCondition(IndexingEventSamplesCHDao.F.PREV_HTTP_CODE, code.value());
    }

    public static TextLikeCondition buildPathCondition(TextLikeCondition.Builder builder) {
        return builder.build(IndexingEventSamplesCHDao.F.PATH);
    }

    public static String getUrlFieldName() {
        return IndexingEventSamplesCHDao.F.PATH;
    }
}
