package ru.yandex.webmaster3.storage.indexing2.samples.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.HttpCodeInfo;

/**
 * Created by leonidrom on 17/02/2017.
 */
public final class IndexedUrlEventSample {
    private final String url;
    private final HttpCodeInfo previousCode;
    private final HttpCodeInfo currentCode;
    private final DateTime lastAccess;

    public IndexedUrlEventSample(String url, HttpCodeInfo previousCode, HttpCodeInfo currentCode,
                                 DateTime lastAccess) {
        this.url = url;
        this.previousCode = previousCode;
        this.currentCode = currentCode;
        this.lastAccess = lastAccess;
    }

    public String getUrl() {
        return url;
    }

    public HttpCodeInfo getCurrentCode() {
        return currentCode;
    }


    public HttpCodeInfo getPreviousCode() {
        return previousCode;
    }

    public DateTime getLastAccess() {
        return lastAccess;
    }
}


