package ru.yandex.webmaster3.storage.indexing2.samples.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.HttpCodeInfo;

/**
 * Created by leonidrom on 17/02/2017.
 */
public final class IndexedUrlSample {
    private final String relativeUrl;
    private final HttpCodeInfo currentCode;
    private final DateTime lastAccess;

    public IndexedUrlSample(String relativeUrl, HttpCodeInfo currentCode, DateTime lastAccess) {
        this.relativeUrl = relativeUrl;
        this.currentCode = currentCode;
        this.lastAccess = lastAccess;
    }

    public DateTime getLastAccess() {
        return lastAccess;
    }

    public String getUrl() {
        return relativeUrl;
    }

    public HttpCodeInfo getCurrentCode() {
        return currentCode;
    }
}
