package ru.yandex.webmaster3.storage.links;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author leonidrom
 */
@Description("Тип битых ссылок")
public enum BrokenLinkType {
    @Description("Входящие, они же внешние")
    INCOMING,

    @Description("Исходящие")
    OUTGOING,

    @Description("Внутренние")
    INTERNAL,
    ;

    public static EnumResolver<BrokenLinkType> R = EnumResolver.er(BrokenLinkType.class);
}
