package ru.yandex.webmaster3.storage.links2;

import java.util.List;
import java.util.Set;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.link.HostLinkSample;
import ru.yandex.webmaster3.core.links2.HostLinkSourceSample;
import ru.yandex.webmaster3.storage.clickhouse.LegacyMdbTableStorage;
import ru.yandex.webmaster3.storage.links.InternalLinksOrder;
import ru.yandex.webmaster3.storage.links.dao.InternalLinkSamplesCHDao;
import ru.yandex.webmaster3.storage.links2.dao.ExternalLinks2SamplesCHDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;
import ru.yandex.webmaster3.storage.util.clickhouse2.query.OrderBy;

/**
 * @author tsyplyaev
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class Link2SamplesService {
    
    private final InternalLinkSamplesCHDao mdbInternalLinkSamplesCHDao;
    private final ExternalLinks2SamplesCHDao mdbExternalLinks2SamplesCHDao;
    private final LegacyMdbTableStorage legacyMdbTableStorage;

    public long countInternalSamples(WebmasterHostId hostId, Set<Integer> httpFilter) {
        var table = legacyMdbTableStorage.getInternalLinkSamplesTable();
        return mdbInternalLinkSamplesCHDao.countSamples(table, hostId, httpFilter);
    }

   public List<HostLinkSample> listInternalSamples(WebmasterHostId hostId, Set<Integer> httpFilter,
            long limitFrom, int limitSize) {
        return listInternalSamples(hostId, httpFilter, InternalLinksOrder.DATE, limitFrom, limitSize);
   }

    public List<HostLinkSample> listInternalSamples(WebmasterHostId hostId, Set<Integer> httpFilter,
            InternalLinksOrder orderBy, long limitFrom, int limitSize) {
        var table = legacyMdbTableStorage.getInternalLinkSamplesTable();
        return mdbInternalLinkSamplesCHDao.listSamples(table, hostId, httpFilter, orderBy, limitFrom, limitSize);
    }

    public long countExternalSamples(WebmasterHostId hostId, boolean onlyBroken, boolean deleted, Condition parameterCondition) {
        var table = deleted ? legacyMdbTableStorage.getExternalDeletedLinkSamplesTable() : legacyMdbTableStorage.getExternalLinkSamplesTable();
        return mdbExternalLinks2SamplesCHDao.countSamples(table, hostId, parameterCondition, onlyBroken);
    }

    public long countExternalSourceSamples(WebmasterHostId hostId, Condition condition, boolean filterBroken, boolean deleted) {
        var table = deleted ? legacyMdbTableStorage.getExternalDeletedLinkSamplesTable() : legacyMdbTableStorage.getExternalLinkSamplesTable();
        return mdbExternalLinks2SamplesCHDao.countSourceSamples(table, hostId, condition, filterBroken);
    }

    public String getLinksTableName() {
        return legacyMdbTableStorage.getExternalLinkSamplesTable().getDistributedTableName();
    }

    public List<HostLinkSample> listExternalSamples(WebmasterHostId hostId, long limitFrom, int limitSize,
            Condition parameterCondition,
            boolean filterBroken,
            ExternalLinksOrder orderBy, OrderBy.Direction orderDirection, boolean deleted)
    {
        var table = deleted ? legacyMdbTableStorage.getExternalDeletedLinkSamplesTable() : legacyMdbTableStorage.getExternalLinkSamplesTable();
        return mdbExternalLinks2SamplesCHDao.listSamples(table, hostId, limitFrom, limitSize,
                            parameterCondition, filterBroken, orderBy, orderDirection, deleted);
    }

    public List<HostLinkSourceSample> listExternalSourceSamples(WebmasterHostId hostId, long limitFrom, long limitSize,
            Condition condition,
            Boolean filterBroken,
            ExternalLinksGroupedOrder orderBy, OrderBy.Direction orderDirection, boolean deleted)
    {
        var table = deleted ? legacyMdbTableStorage.getExternalDeletedLinkSamplesTable() : legacyMdbTableStorage.getExternalLinkSamplesTable();
        return mdbExternalLinks2SamplesCHDao.listSourceSamples(table, hostId,
                            limitFrom, limitSize, condition, filterBroken, orderBy, orderDirection, deleted);
    }
}
