package ru.yandex.webmaster3.storage.logging;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

import java.util.UUID;

/**
 * @author tsyplyaev
 */
public class TaskLogEntry {
    public enum EventType implements IntEnum {
        START(0),
        FINISH(1),
        ERROR(2);

        private final int value;

        EventType(int value) {
            this.value = value;
        }

        @Override
        @JsonIgnore
        public int value() {
            return value;
        }

        public static final IntEnumResolver<EventType> R = IntEnumResolver.r(EventType.class);
    }

    private final DateTime date;
    private final String taskType;
    private final EventType eventType;
    private final String hostName;

    private final UUID runId;
    private final Long runTime;
    private final JsonNode state;
    private final JsonNode error;

    public TaskLogEntry(@JsonProperty("date") DateTime date,
                        @JsonProperty("taskType") String taskType,
                        @JsonProperty("eventType") EventType eventType,
                        @JsonProperty("hostName") String hostName,
                        @JsonProperty("runId") UUID runId,
                        @JsonProperty("runTime") Long runTime,
                        @JsonProperty("state") JsonNode state,
                        @JsonProperty("error") JsonNode error) {
        this.date = date;
        this.taskType = taskType;
        this.eventType = eventType;
        this.hostName = hostName;
        this.runId = runId;
        this.runTime = runTime;
        this.state = state;
        this.error = error;
    }

    public DateTime getDate() {
        return date;
    }

    public String getTaskType() {
        return taskType;
    }

    public EventType getEventType() {
        return eventType;
    }

    public String getHostName() {
        return hostName;
    }

    public UUID getRunId() {
        return runId;
    }

    public Long getRunTime() {
        return runTime;
    }

    public JsonNode getState() {
        return state;
    }

    public JsonNode getError() {
        return error;
    }

    @Override
    public String toString() {
        return "TaskLogEntry{" +
                "date=" + date +
                ", taskType='" + taskType + '\'' +
                ", eventType=" + eventType +
                ", hostName='" + hostName + '\'' +
                ", runId=" + runId +
                ", runTime=" + runTime +
                ", state=" + state +
                ", error=" + error +
                '}';
    }
}
