package ru.yandex.webmaster3.storage.mdb.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;
import lombok.Value;

/**
 * Created by Oleg Bazdyrev on 23/09/2020.
 */
@Value
@AllArgsConstructor(onConstructor_ = @JsonCreator)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MdbClickhouseHost {

    public static final TypeReference<List<MdbClickhouseHost>> LIST_REFERENCE = new TypeReference<>() {};

    String name; //aka fqdn
    String clusterId;
    String zoneId; // man|iva|sas etc
    MdbClickhouseServiceType type;
    MdbClickhouseServiceHealth health;
    String subnetId;
    boolean assignPublicIp;
    String shardName; //shard1
    MdbClickhouseResources resources;
    List<MdbClickhouseService> services;

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class MdbClickhouseResources {
        String resourcePresetId;
        String diskSize;
        String diskTypeId;
    }

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class MdbClickhouseService {
        MdbClickhouseServiceType type;
        MdbClickhouseServiceHealth health;
    }
}
