package ru.yandex.webmaster3.storage.metrika.dao;

import ru.yandex.webmaster3.storage.AbstractFilter;
import ru.yandex.webmaster3.storage.TextFilterUtil;
import ru.yandex.webmaster3.storage.metrika.data.MetrikaCrawlSampleField;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;

import java.util.List;

/**
 * @author leonidrom
 */
public class MetrikaCrawlSampleCondition {
    public static Condition makeCondition(List<? extends AbstractFilter<MetrikaCrawlSampleField>> filters) {
        Condition condition = Condition.trueCondition();
        if (filters == null) {
            return condition;
        }

        for (AbstractFilter<MetrikaCrawlSampleField> filter : filters) {
            switch (filter.getIndicator()) {
                case URL:
                    condition = condition.andThen(TextFilterUtil.getTextCondition(filter, getUrlFieldName()));
                    break;

                case TITLE:
                    condition = condition.andThen(TextFilterUtil.getTextCondition(filter, getTitleFieldName()));
                    break;

                default:
                    throw new RuntimeException("Not implemented filter for indicator " + filter.getIndicator());
            }
        }

        return condition;
    }

    public static String getUrlFieldName() {
        return MetrikaCrawlSamplesCHDao.F.URL;
    }

    public static String getTitleFieldName() {
        return MetrikaCrawlSamplesCHDao.F.TITLE;
    }
}
