package ru.yandex.webmaster3.storage.metrika.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

/**
 * @author leonidrom
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class MetrikaCrawlLostHitsUrlSample {
    private final String url;
    private final int lostHits;
    private final double timeUntilDeployingInHrs;

    @JsonCreator
    public MetrikaCrawlLostHitsUrlSample(
            @JsonProperty("url") String url,
            @JsonProperty("lostHits") int lostHits,
            @JsonProperty("timeUntilDeployingInHrs") double timeUntilDeployingInHrs) {
        this.url = url;
        this.lostHits = lostHits;
        this.timeUntilDeployingInHrs = timeUntilDeployingInHrs;
    }
}

