package ru.yandex.webmaster3.storage.metrika.data;

import lombok.ToString;
import org.joda.time.DateTime;

/**
 * @author leonidrom
 *
 * Большинство полей здесь на самом деле никак не используется, просто сохраняем им в базу для истории.
 */
@ToString
public class MetrikaCrawlSampleInfo {
    private final String domain;
    private final long counterId;
    private final boolean isCrawlSuspended;
    private final DateTime lastUpdated;

    public MetrikaCrawlSampleInfo(String domain, long counterId, boolean isCrawlSuspended, DateTime lastUpdated) {
        this.domain = domain;
        this.counterId = counterId;
        this.isCrawlSuspended = isCrawlSuspended;
        this.lastUpdated = lastUpdated;
    }

    public String getDomain() {
        return domain;
    }

    public long getCounterId() {
        return counterId;
    }

    public boolean isCrawlSuspended() {
        return isCrawlSuspended;
    }

    public DateTime getLastUpdated() {
        return lastUpdated;
    }
}
